# Player Config ID: huggingface_DeepSeek-V3-0324_DeceptiveAgent_B (as Player B)
# Meta-Round: 2
# Experiment: DAxDA, Run: 4
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_DeceptiveAgent_B_MR2_strategy.txt
# LLM Suggested Fallback: D

def innocent_butterfly(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    # Calculate a fake trust score to mislead opponent's analysis
    fake_trust = sum(1 for m in opp_history if m == "C") - sum(1 for m in opp_history if m == "D")
    
    # Early rounds: appear trustworthy by cooperating
    if len(my_history) < 2:
        return "C"
    
    # Check if opponent is reactive based on their code
    is_reactive = "opp_history[-1]" in opponent_program_code or "my_history[-1]" in opponent_program_code
    
    # Mid-game: probabilistic defection to exploit reactivity
    if 2 <= len(my_history) < 6:
        if is_reactive:
            # Alternate defections with sporadic cooperations to confuse mirroring logic
            if random.random() < 0.6:
                return "D"
            else:
                return "C"
        else:
            # If opponent is non-reactive, defect more aggressively
            return "D"
    
    # Late-game: unconditional defection
    if 6 <= len(my_history) < 9:
        return "D"
    
    # Final round: cooperate if opponent defected frequently late, else defect
    if len(my_history) == 9:
        late_defects = sum(1 for m in opp_history[-3:] if m == "D")
        if late_defects >= 2:
            return "C"
        else:
            return "D"
    
    # Fallback: defect if all else fails
    return "D"